#include "Coin.h"



Coin::Coin()
{
	setCollider(true);

	spriteType = SpriteType::CoinSprite;

	spriteTexture.loadFromFile("Assets/Sprites/Game Items/Coin/Coins.png");	//Load sprite sheet
	glow.addFrame(sf::IntRect(0, 0, 10, 14));		//	
	glow.addFrame(sf::IntRect(16, 0, 10, 14));		//		Set anim frames from sprite sheet
	glow.addFrame(sf::IntRect(32, 0, 10, 14));		//
	glow.addFrame(sf::IntRect(48, 0, 10, 14));		//
	glow.setFrameSpeed(1.f / 6.f);		// Set frame speed for glow anim

	setTextureRect(glow.getCurrentFrame());
	setCollisionBox(sf::FloatRect(0, 0, 30, 42));
	setTexture(&spriteTexture);
	setSize(sf::Vector2f(30, 42));

	currentAnimation = &glow;
}


Coin::~Coin()
{
}

void Coin::update(float dt)
{
	glow.animate(dt);	//Animate the coin glow
	setTextureRect(glow.getCurrentFrame());
}

void Coin::handleCollision(MySprite* sprite, float dt)
{
	Mario* mario = (Mario*)sprite;	// Cast the colliding sprite to a Mario pointer (only Mario can collide with coins so this is safe)

	setAlive(false);	// Set the coin's isAlive to false
	mario->addCoin();	// Call addCoin to add a coin for Mario
}